/**
 * 
 */
package org.eclipse.smila.solr.admin;

import java.util.List;
import java.util.Map;

import org.eclipse.smila.datamodel.AnyMap;

/**
 * @author pwissel
 * 
 */
public interface SolrAdministration {

  static final String ACTION = "action";

  static final String CORE = "core";

  static final String NAME = "name";

  static final String INSTANCE_DIR = "instanceDir";

  static final String OTHER = "other";

  static final String DELETE_INDEX = "deleteIndex";

  static final String SRC_CORE = "srcCore";

  public AnyMap status() throws SolrAdministrationException;

  public AnyMap status(final String core) throws SolrAdministrationException;

  public AnyMap create(final String name, final String instanceDir) throws SolrAdministrationException;

  public AnyMap create(final String name, final String instanceDir, final Map<String, String[]> otherParams)
    throws SolrAdministrationException;

  public AnyMap reload(final String core) throws SolrAdministrationException;

  public AnyMap rename(final String core, final String other) throws SolrAdministrationException;

  public AnyMap swap(final String core, final String other) throws SolrAdministrationException;

  public AnyMap unload(final String core) throws SolrAdministrationException;

  public AnyMap unload(final String core, final boolean deleteIndex) throws SolrAdministrationException;

  public AnyMap load(final String core) throws SolrAdministrationException;

  public AnyMap mergeIndexes(final String core, final String... sourceCore) throws SolrAdministrationException;

  /** get all names of cores available in this server. */
  List<String> getCoreNames() throws Exception;

  /** get the names of fields defined in the named core. */
  List<String> getFieldNames(final String core) throws Exception;

  /** clear all internal caches after external admin operations (e.g. cached field names). */
  void clearCoreCaches();

  /** clear internal caches for named core after external admin operations (e.g. cached field names). */
  void clearCoreCache(String core);

  public AnyMap optimize(String core) throws SolrAdministrationException;

  public AnyMap ping(String core) throws SolrAdministrationException;

}
