package org.eclipse.smila.solr.search;

import org.apache.solr.common.params.SpellingParams;

/**
 * constants used in the result of solr which have not been defined on the solr side in {@link SpellingParams}
 * 
 * @author tmenzel
 * */
public interface SpellcheckSolrConstants extends SpellingParams {

  /** FREQ. */
  String FREQ = "freq";

  /** ORIG_FREQ. */
  String ORIG_FREQ = "origFreq";

  /** END_OFFSET. */
  String END_OFFSET = "endOffset";

  /** START_OFFSET. */
  String START_OFFSET = "startOffset";

  /** NUM_FOUND. */
  String NUM_FOUND = "numFound";

  /** DYM_SUGGESTIONS. */
  String SUGGESTIONS = "suggestions";

  /**
   * Parameter collation.
   */
  String COLLATION = "collation";

  /**
   * Parameter spellcheck.
   */
  String SPELLCHECK = "spellcheck";

}
