/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.solr.server;

import java.util.Collection;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;

/** {@link SolrServer}s manager for embedded Solr servers. */
public class SolrEmbeddedServers extends SolrServers {

  private final CoreContainer _container;

  /** create manager for given core container. */
  public SolrEmbeddedServers(CoreContainer container) {
    _container = container;
  }

  @Override
  public SolrServer getAdminServer() throws SolrServerException {
    return createServer(getAdminCoreName());
  }

  @Override
  protected SolrServer createServer(String coreName) throws SolrServerException {
    if (!_container.getCoreNames().contains(coreName)) {
      throw new SolrServerException("No configuration found in solr.home '" + _container.getSolrHome()
        + "' for core with name: " + coreName);
    }
    return new EmbeddedSolrServer(_container, coreName);
  }

  /** get some core name to use for admin operations (not related to a single core). */
  private String getAdminCoreName() throws SolrServerException {
    Collection<String> coreNames = _container.getCoreNames();
    if (coreNames.isEmpty()) {
      throw new SolrServerException("No core available in configuration solr.home '" + _container.getSolrHome()
        + "' for admin operations");
    }
    return coreNames.iterator().next();
  }

}
