/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker;

/**
 * May be used by workers to denote that a task cannot be performed now and should be performed later.
 */
public class PostponeTaskException extends Exception {

  /**
   * The serial version id.
   */
  private static final long serialVersionUID = 1L;

  /**
   * @param message
   *          The error message
   * @param cause
   *          The cause
   */
  public PostponeTaskException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /**
   * @param message
   *          The error message
   */
  public PostponeTaskException(final String message) {
    super(message);
  }

}
