/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.processing.httphandler;

import java.net.MalformedURLException;
import java.util.Set;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.HttpStatus;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.processing.ProcessingException;

/**
 * Implements the handling of HTTP requests for reading defined pipelets.
 */
public class PipeletsHandler extends JsonRequestHandler {

  /** PipeletTracker service. */
  private PipeletTracker _pipeletTracker;

  /**
   * {@inheritDoc}
   * 
   * PipelineListHandler supports GET.
   */
  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "GET".equals(method);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord,
    final HttpExchange exchange) throws Exception {
    return getPipelineList(getRequestHost(exchange), requestUri);
  }

  /** create list of pipelines descriptions. */
  private Object getPipelineList(final String requestHost, final String requestUri) throws MalformedURLException {
    final AnyMap result = FACTORY.createAnyMap();
    final AnySeq pipelets = FACTORY.createAnySeq();
    final Set<String> names = _pipeletTracker.getRegisteredPipeletDescriptions().keySet();
    for (final String name : names) {
      final AnyMap pipelet = FACTORY.createAnyMap();
      pipelet.put(PipeletTracker.KEY_CLASS, name);
      pipelet.put("url", URLCreator.create(requestHost, requestUri, name).toString());
      pipelets.add(pipelet);
    }
    result.put("pipelets", pipelets);
    return result;
  }

  @Override
  protected int getErrorStatus(final String method, final String requestUri, final Throwable ex) {
    if (ex instanceof ProcessingException) {
      return ((ProcessingException) ex).isRecoverable() ? HttpStatus.INTERNAL_SERVER_ERROR : HttpStatus.BAD_REQUEST;
    } else if (ex instanceof IllegalArgumentException) {
      return HttpStatus.BAD_REQUEST;
    }
    return super.getErrorStatus(method, requestUri, ex);
  }

  /** set OSGI service. */
  public void setPipeletTracker(final PipeletTracker tracker) {
    _pipeletTracker = tracker;
  }

  /** unset OSGI service. */
  public void unsetPipeletTracker(final PipeletTracker tracker) {
    if (_pipeletTracker == tracker) {
      _pipeletTracker = null;
    }
  }
}
