package org.eclipse.smila.utils.service;

import org.osgi.service.component.ComponentException;

/**
 * @author tmenzel
 * 
 */
public class ServiceNotBoundException extends ComponentException {

  /** serialVersionUID. */
  private static final long serialVersionUID = 1L;

  /**
   * @param message
   * @param cause
   */
  public ServiceNotBoundException(String message, Throwable cause) {
    super(message, cause);
  }

  /**
   * @param message
   */
  public ServiceNotBoundException(String message) {
    super(message);
  }

  /**
   * @param effectMessage
   */
  public ServiceNotBoundException(Class<?> serviceClass, String effectMessage) {
    super(effectMessage + " Missing Service is of Type: " + serviceClass.getName());
  }

  /**
   * @param cause
   */
  public ServiceNotBoundException(Throwable cause) {
    super(cause);
  }

}
