/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing;

/** Parameter name and possible values to specify usage of DeltaService during update. */
public enum DeltaImportStrategy {

  /** don't use delta service, just import. */
  DISABLED("disabled"),
  /** initial import: set state for imported records, don't check or delete. */
  INITIAL("initial"),
  /** add-and-update: set state for imported records, check for unchanged objects, don't delete removed records. */
  ADDITIVE("additive"),
  /** use all features: set state for imported records, check for unchanged objects, delete removed records. */
  FULL("full");

  /** name of task parameter. */
  public static final String TASK_PARAM = "deltaImportStrategy";

  /** external form of value. */
  private final String _externalName;

  /** create instance. */
  private DeltaImportStrategy(final String externalName) {
    _externalName = externalName;
  }

  /** get external form of value. */
  public String getExternalName() {
    return _externalName;
  }

  /** return true if checking the delta state is disabled in this mode. */
  public boolean isDeltaCheckDisabled() {
    return this == DISABLED || this == INITIAL;
  }

  /** return true if deleting unvisited records is enabled in this mode. */
  public boolean isDeltaDeleteEnabled() {
    return this == FULL;
  }

  /** return true if setting the delta state is enable in this mode. */
  public boolean isSetStateEnabled() {
    return this != DISABLED;
  }
}
