/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskmanager;

/**
 * Exception class for Taskmanager specific exception.
 */
public class TaskmanagerException extends Exception {
  /**
   * exceptions are serializable.
   */
  private static final long serialVersionUID = 1L;

  /**
   * constructor with message.
   * 
   * @param message
   *          detailed error message.
   */
  public TaskmanagerException(String message) {
    super(message);
  }

  /**
   * constructor with causing exception.
   * 
   * @param cause
   *          exception that caused the error.
   */
  public TaskmanagerException(Throwable cause) {
    super(cause);
  }

  /**
   * constructor with message and causing exception.
   * 
   * @param message
   *          detailed error message.
   * @param cause
   *          exception that caused the error.
   */
  public TaskmanagerException(String message, Throwable cause) {
    super(message, cause);
  }
}
