/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.examples.eratosthenes;

import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.jacob.SynchChannelListener;
import org.apache.ode.jacob.examples.eratosthenes.NaturalNumberStreamChannel;
import org.apache.ode.jacob.examples.eratosthenes.NaturalNumberStreamChannelListener;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.jacob.vpu.JacobVPU;

public class Sieve
extends JacobRunnable {
    private static final long serialVersionUID = -1303509567096202776L;
    private static int _cnt = 0;
    private static int _last = 0;

    public void run() {
        NaturalNumberStreamChannel naturalNumberStreamChannel = this.newChannel(NaturalNumberStreamChannel.class);
        NaturalNumberStreamChannel naturalNumberStreamChannel2 = this.newChannel(NaturalNumberStreamChannel.class);
        Sieve.instance(new Counter(naturalNumberStreamChannel, 2));
        Sieve.instance(new Head(naturalNumberStreamChannel, naturalNumberStreamChannel2));
        Sieve.instance(new Print(naturalNumberStreamChannel2));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("JACOB Sieve of Eratosthenes Prime Number Generator Demonstration");
            System.err.println("usage: java " + Sieve.class.getName() + " requested-prime");
            System.err.println("  requested-prime = which prime to show (0->inf)");
            System.exit(1);
        } else {
            int n = Integer.parseInt(stringArray[0]);
            JacobVPU jacobVPU = new JacobVPU();
            jacobVPU.setContext(new ExecutionQueueImpl(null));
            jacobVPU.inject(new Sieve());
            while (_cnt != n) {
                jacobVPU.execute();
            }
            System.err.println("The " + _cnt + "th prime is " + _last);
        }
    }

    private static class PrimeFilter
    extends JacobRunnable {
        private static final long serialVersionUID = 1569523200422202448L;
        private int _prime;
        private NaturalNumberStreamChannel _in;
        private NaturalNumberStreamChannel _out;

        public PrimeFilter(int n, NaturalNumberStreamChannel naturalNumberStreamChannel, NaturalNumberStreamChannel naturalNumberStreamChannel2) {
            this._prime = n;
            this._in = naturalNumberStreamChannel;
            this._out = naturalNumberStreamChannel2;
        }

        public void run() {
            PrimeFilter.object(true, new NaturalNumberStreamChannelListener(this._in){
                private static final long serialVersionUID = 6625386475773075604L;

                public void val(int n, final SynchChannel synchChannel) {
                    if (n % PrimeFilter.this._prime != 0) {
                        PrimeFilter.this._out.val(n, (SynchChannel)1.object(new SynchChannelListener(this.newChannel(SynchChannel.class)){
                            private static final long serialVersionUID = 2523405590764193613L;

                            public void ret() {
                                synchChannel.ret();
                            }
                        }));
                    } else {
                        synchChannel.ret();
                    }
                }
            });
        }
    }

    private static final class Print
    extends JacobRunnable {
        private static final long serialVersionUID = -3134193737519487672L;
        private NaturalNumberStreamChannel _in;

        public Print(NaturalNumberStreamChannel naturalNumberStreamChannel) {
            this._in = naturalNumberStreamChannel;
        }

        public void run() {
            Print.object(true, new NaturalNumberStreamChannelListener(this._in){
                private static final long serialVersionUID = 7671019806323866866L;

                public void val(int n, SynchChannel synchChannel) {
                    _cnt++;
                    _last = n;
                    System.out.println("PRIME: " + n);
                    synchChannel.ret();
                }
            });
        }
    }

    private static final class Head
    extends JacobRunnable {
        private static final long serialVersionUID = 1791641314141082728L;
        NaturalNumberStreamChannel _in;
        NaturalNumberStreamChannel _primes;

        public Head(NaturalNumberStreamChannel naturalNumberStreamChannel, NaturalNumberStreamChannel naturalNumberStreamChannel2) {
            this._in = naturalNumberStreamChannel;
            this._primes = naturalNumberStreamChannel2;
        }

        public void run() {
            Head.object(new NaturalNumberStreamChannelListener(this._in){
                private static final long serialVersionUID = -2145752474431263689L;

                public void val(final int n, final SynchChannel synchChannel) {
                    Head.this._primes.val(n, (SynchChannel)1.object(new SynchChannelListener(this.newChannel(SynchChannel.class)){
                        private static final long serialVersionUID = -3009595654233593893L;

                        public void ret() {
                            NaturalNumberStreamChannel naturalNumberStreamChannel = this.newChannel(NaturalNumberStreamChannel.class);
                            Head.1.instance(new PrimeFilter(n, Head.this._in, naturalNumberStreamChannel));
                            Head.1.instance(new Head(naturalNumberStreamChannel, Head.this._primes));
                            synchChannel.ret();
                        }
                    }));
                }
            });
        }
    }

    private static class Counter
    extends JacobRunnable {
        private static final long serialVersionUID = 4739323750438991003L;
        private NaturalNumberStreamChannel _out;
        private int _n;

        public Counter(NaturalNumberStreamChannel naturalNumberStreamChannel, int n) {
            this._out = naturalNumberStreamChannel;
            this._n = n;
        }

        public void run() {
            this._out.val(this._n, (SynchChannel)Counter.object(new SynchChannelListener(this.newChannel(SynchChannel.class)){
                private static final long serialVersionUID = -4336285925619915276L;

                public void ret() {
                    1.instance(new Counter(Counter.this._out, Counter.this._n + 1));
                }
            }));
        }
    }

    public class Foo {
    }
}

