/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetIndoubtTransaction;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDriver;

public class NetXAConnection {
    private NetConnection netCon;

    public NetXAConnection(NetLogWriter netLogWriter, String user, String password, ClientBaseDataSource dataSource, int rmId, boolean isXAConn, ClientPooledConnection cpc) throws SqlException {
        this.netCon = this.createNetConnection(netLogWriter, user, password, dataSource, rmId, isXAConn, cpc);
        this.checkPlatformVersion();
    }

    protected void finalize() throws Throwable {
        this.netCon.finalize();
    }

    public void setCorrelatorToken(byte[] crttoken) {
        this.netCon.crrtkn_ = crttoken;
    }

    public byte[] getCorrelatorToken() {
        return this.netCon.crrtkn_;
    }

    void setNetXAResource(NetXAResource xares) {
        this.netCon.xares_ = xares;
    }

    public void writeLocalXAStart_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXAStart(this.netCon);
    }

    public void readLocalXAStart_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXAStart(this.netCon);
    }

    public void writeLocalXACommit_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXACommit(this.netCon);
    }

    public void readLocalXACommit_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXACommit(this.netCon);
    }

    public void writeLocalXARollback_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXARollback(this.netCon);
    }

    public void readLocalXARollback_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXARollback(this.netCon);
    }

    public void writeTransactionStart(Statement statement) throws SqlException {
        if (!this.netCon.isXAConnection()) {
            return;
        }
        int xaState = this.netCon.getXAState();
        this.netCon.xares_.exceptionsOnXA = null;
    }

    public byte[] getUOWID(Xid xid) {
        NetIndoubtTransaction indoubtTxn = (NetIndoubtTransaction)this.netCon.indoubtTransactions_.get(xid);
        if (indoubtTxn == null) {
            return null;
        }
        byte[] uowid = indoubtTxn.getUOWID();
        return uowid;
    }

    public int getPort(Xid xid) {
        NetIndoubtTransaction indoubtTxn = (NetIndoubtTransaction)this.netCon.indoubtTransactions_.get(xid);
        if (indoubtTxn == null) {
            return -1;
        }
        return indoubtTxn.getPort();
    }

    public void writeCommit() throws SqlException {
        int xaState = this.netCon.getXAState();
        if (xaState == 0) {
            this.netCon.xares_.callInfoArray_[this.netCon.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
            this.writeLocalXACommit_();
        }
    }

    public void readCommit() throws SqlException {
        int xaState = this.netCon.getXAState();
        NetXACallInfo callInfo = this.netCon.xares_.callInfoArray_[this.netCon.currXACallInfoOffset_];
        callInfo.xaRetVal_ = 0;
        if (xaState == 0) {
            this.readLocalXACommit_();
        }
        if (callInfo.xaRetVal_ != 0) {
            callInfo.xaFunction_ = 1;
            this.netCon.xares_.xaRetValErrorAccumSQL(callInfo, 0);
            callInfo.xaRetVal_ = 0;
            throw this.netCon.xares_.exceptionsOnXA;
        }
    }

    public void writeRollback() throws SqlException {
        NetXAResource cfr_ignored_0 = this.netCon.xares_;
        this.netCon.xares_.callInfoArray_[this.netCon.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
        this.writeLocalXARollback_();
    }

    public void readRollback() throws SqlException {
        NetXACallInfo callInfo = this.netCon.xares_.callInfoArray_[this.netCon.currXACallInfoOffset_];
        callInfo.xaRetVal_ = 0;
        this.readLocalXARollback_();
        if (callInfo.xaRetVal_ != 0) {
            callInfo.xaFunction_ = 6;
            this.netCon.xares_.xaRetValErrorAccumSQL(callInfo, 0);
            callInfo.xaRetVal_ = 0;
            throw this.netCon.xares_.exceptionsOnXA;
        }
        this.netCon.setXAState(0);
    }

    public NetConnection getNetConnection() {
        return this.netCon;
    }

    private void checkPlatformVersion() throws SqlException {
        int supportedVersion = 8;
        if (this.netCon.xaHostVersion_ >= supportedVersion) {
            return;
        }
        String platform = null;
        platform = "Linux, Unix, Windows";
        throw new SqlException(this.netCon.agent_.logWriter_, new ClientMessageId("XN012.S"), (Object)platform, (Object)new Integer(supportedVersion), new Integer(this.netCon.xaHostVersion_));
    }

    protected NetConnection createNetConnection(NetLogWriter netLogWriter, String user, String password, ClientBaseDataSource dataSource, int rmId, boolean isXAConn, ClientPooledConnection cpc) throws SqlException {
        return (NetConnection)ClientDriver.getFactory().newNetConnection(netLogWriter, user, password, dataSource, rmId, isXAConn, cpc);
    }
}

