/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.events.LDAPEvent;
import com.novell.ldap.events.LDAPEventListener;
import com.novell.ldap.events.LDAPExceptionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class LDAPEventSource {
    private long sleepTime = 1000L;
    private Map listenermap = new TreeMap(new HashComparator());

    protected void stopeventpolling(LDAPEventListener lDAPEventListener) throws LDAPException {
        if (lDAPEventListener == null) {
            throw new IllegalArgumentException("No parameter can be Null.");
        }
        if (!this.listenermap.containsKey(lDAPEventListener)) {
            throw new LDAPException(null, 80, "This in not a registered Listener");
        }
        Iterator iterator = ((List)this.listenermap.get(lDAPEventListener)).iterator();
        this.listenermap.remove(lDAPEventListener);
        while (iterator.hasNext()) {
            EventsGenerator eventsGenerator = (EventsGenerator)iterator.next();
            eventsGenerator.stopEventGeneration();
        }
    }

    protected void pollforevents(LDAPMessageQueue lDAPMessageQueue, LDAPConnection lDAPConnection, LDAPEventListener lDAPEventListener, int n, LDAPEventSource lDAPEventSource) {
        if (lDAPMessageQueue == null || lDAPConnection == null || lDAPEventListener == null || lDAPEventSource == null) {
            throw new IllegalArgumentException("No parameter can be Null.");
        }
        EventsGenerator eventsGenerator = this.createListeningThread(lDAPMessageQueue, lDAPConnection, lDAPEventListener, n, lDAPEventSource);
        eventsGenerator.start();
        List<EventsGenerator> list = null;
        if (this.listenermap.containsKey(lDAPEventListener)) {
            list = (List)this.listenermap.get(lDAPEventListener);
        } else {
            list = new ArrayList();
            this.listenermap.put(lDAPEventListener, list);
        }
        list.add(eventsGenerator);
    }

    protected EventsGenerator createListeningThread(LDAPMessageQueue lDAPMessageQueue, LDAPConnection lDAPConnection, LDAPEventListener lDAPEventListener, int n, LDAPEventSource lDAPEventSource) {
        return new EventsGenerator(lDAPEventSource, lDAPMessageQueue, lDAPEventListener, lDAPConnection, n);
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Sleep Time must be a non-zero positive number");
        }
        this.sleepTime = l;
    }

    protected class EventsGenerator
    extends Thread {
        private final LDAPMessageQueue searchqueue;
        private final LDAPEventSource eventsource;
        private final int messageid;
        private final LDAPConnection ldapconnection;
        private final LDAPEventListener eventlistener;
        private volatile boolean isrunning = true;

        public EventsGenerator(LDAPEventSource lDAPEventSource2, LDAPMessageQueue lDAPMessageQueue, LDAPEventListener lDAPEventListener, LDAPConnection lDAPConnection, int n) {
            this.eventsource = lDAPEventSource2;
            this.searchqueue = lDAPMessageQueue;
            this.eventlistener = lDAPEventListener;
            this.ldapconnection = lDAPConnection;
            this.messageid = n;
        }

        public final void run() {
            while (this.isrunning) {
                try {
                    LDAPMessage lDAPMessage = null;
                    while (this.isrunning && !this.searchqueue.isResponseReceived(this.messageid)) {
                        try {
                            EventsGenerator.sleep(LDAPEventSource.this.sleepTime);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.isrunning) {
                        lDAPMessage = this.searchqueue.getResponse(this.messageid);
                    }
                    if (lDAPMessage == null) continue;
                    this.processmessage(lDAPMessage);
                }
                catch (LDAPException lDAPException) {
                    LDAPExceptionEvent lDAPExceptionEvent = new LDAPExceptionEvent(this.eventsource, lDAPException, null);
                    this.eventlistener.ldapExceptionNotification(lDAPExceptionEvent);
                }
            }
        }

        protected void processmessage(LDAPMessage lDAPMessage) {
            if (lDAPMessage instanceof LDAPResponse) {
                try {
                    ((LDAPResponse)lDAPMessage).chkResultCode();
                    this.eventlistener.ldapEventNotification(new LDAPEvent(this.eventsource, lDAPMessage, -1, -1));
                }
                catch (LDAPException lDAPException) {
                    LDAPExceptionEvent lDAPExceptionEvent = new LDAPExceptionEvent(this.eventsource, lDAPException, lDAPMessage);
                    this.eventlistener.ldapExceptionNotification(lDAPExceptionEvent);
                }
            } else {
                this.eventlistener.ldapEventNotification(new LDAPEvent(this.eventsource, lDAPMessage, -1, -1));
            }
        }

        public final void stopEventGeneration() throws LDAPException {
            this.isrunning = false;
            this.ldapconnection.abandon(this.searchqueue);
        }
    }

    private class HashComparator
    implements Comparator {
        private HashComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = object.hashCode();
            if (n2 > (n = object2.hashCode())) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            return 0;
        }
    }
}

