/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v2;

import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.CompositeActivity;
import org.apache.ode.bpel.compiler.bom.ExtensionActivity;
import org.apache.ode.bpel.compiler.v2.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.v2.ExtensionActivityGeneratorMessages;
import org.apache.ode.bpel.extension.ExtensibleElement;
import org.apache.ode.bpel.extension.ExtensionValidator;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.SerializableElement;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

class ExtensionActivtityGenerator
extends DefaultActivityGenerator {
    private static final ExtensionActivityGeneratorMessages __cmsgs = (ExtensionActivityGeneratorMessages)MessageBundle.getMessages(ExtensionActivityGeneratorMessages.class);

    ExtensionActivtityGenerator() {
    }

    public void compile(OActivity oActivity, Activity activity) {
        ExtensionActivity extensionActivity = (ExtensionActivity)activity;
        OExtensionActivity oExtensionActivity = (OExtensionActivity)oActivity;
        Element element = extensionActivity.getFirstExtensibilityElement();
        try {
            if (element == null) {
                throw new CompilationException(__cmsgs.errMissingExtensionActivityElement());
            }
            if (!this._context.isExtensionDeclared(element.getNamespaceURI())) {
                throw new CompilationException(__cmsgs.errUndeclaredExtensionActivity().setSource(extensionActivity));
            }
            ExtensionValidator extensionValidator = this._context.getExtensionValidator(DOMUtils.getElementQName((Element)element));
            if (extensionValidator != null) {
                extensionValidator.validate((Object)this._context, (ExtensibleElement)extensionActivity);
            }
            oExtensionActivity.extensionName = DOMUtils.getElementQName((Element)element);
            oExtensionActivity.nestedElement = new SerializableElement(element);
            this.compileChildren(oExtensionActivity, extensionActivity);
        }
        catch (CompilationException compilationException) {
            this._context.recoveredFromError(extensionActivity, compilationException);
        }
    }

    public OActivity newInstance(Activity activity) {
        return new OExtensionActivity(this._context.getOProcess(), this._context.getCurrent());
    }

    protected void compileChildren(OExtensionActivity oExtensionActivity, CompositeActivity compositeActivity) {
        for (Activity activity : compositeActivity.getActivities()) {
            try {
                OActivity oActivity = this._context.compile(activity);
                oExtensionActivity.children.add(oActivity);
            }
            catch (CompilationException compilationException) {
                this._context.recoveredFromError(activity, compilationException);
            }
        }
    }
}

