/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.config;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfigUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRepositoryIDs(Repository repository) throws RepositoryException {
        RepositoryConnection con = repository.getConnection();
        try {
            LinkedHashSet<String> idSet = new LinkedHashSet<String>();
            RepositoryResult<Statement> idStatementIter = con.getStatements(null, RepositoryConfigSchema.REPOSITORYID, null, true, new Resource[0]);
            try {
                while (idStatementIter.hasNext()) {
                    Statement idStatement = idStatementIter.next();
                    if (!(idStatement.getObject() instanceof Literal)) continue;
                    Literal idLiteral = (Literal)idStatement.getObject();
                    idSet.add(idLiteral.getLabel());
                }
            }
            finally {
                idStatementIter.close();
            }
            LinkedHashSet<String> linkedHashSet = idSet;
            return linkedHashSet;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRepositoryConfig(Repository repository, String repositoryID) throws RepositoryException, RepositoryConfigException {
        RepositoryConnection con = repository.getConnection();
        try {
            boolean bl = RepositoryConfigUtil.getIDStatement(con, repositoryID) != null;
            return bl;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryConfig getRepositoryConfig(Repository repository, String repositoryID) throws RepositoryConfigException, RepositoryException {
        RepositoryConnection con = repository.getConnection();
        try {
            Statement idStatement = RepositoryConfigUtil.getIDStatement(con, repositoryID);
            if (idStatement == null) {
                RepositoryConfig repositoryConfig = null;
                return repositoryConfig;
            }
            Resource repositoryNode = idStatement.getSubject();
            Resource context = idStatement.getContext();
            if (context == null) {
                throw new RepositoryException("No configuration context for repository " + repositoryID);
            }
            GraphImpl contextGraph = new GraphImpl();
            con.getStatements(null, null, null, true, context).addTo(contextGraph);
            RepositoryConfig repositoryConfig = RepositoryConfig.create(contextGraph, repositoryNode);
            return repositoryConfig;
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRepositoryConfigs(Repository repository, RepositoryConfig ... configs) throws RepositoryException, RepositoryConfigException {
        RepositoryConnection con = repository.getConnection();
        try {
            RepositoryConfigUtil.updateRepositoryConfigs(con, configs);
        }
        finally {
            con.close();
        }
    }

    public static void updateRepositoryConfigs(RepositoryConnection con, RepositoryConfig ... configs) throws RepositoryException, RepositoryConfigException {
        ValueFactory vf = con.getRepository().getValueFactory();
        boolean wasAutoCommit = con.isAutoCommit();
        con.setAutoCommit(false);
        for (RepositoryConfig config : configs) {
            Resource context = RepositoryConfigUtil.getContext(con, config.getID());
            if (context != null) {
                con.clear(context);
            } else {
                context = vf.createBNode();
            }
            con.add(context, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY_CONTEXT, new Resource[0]);
            GraphImpl graph = new GraphImpl(vf);
            config.export(graph);
            con.add(graph, context);
        }
        con.setAutoCommit(wasAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeRepositoryConfigs(Repository repository, String ... repositoryIDs) throws RepositoryException, RepositoryConfigException {
        boolean changed = false;
        RepositoryConnection con = repository.getConnection();
        try {
            con.setAutoCommit(false);
            for (String id : repositoryIDs) {
                Resource context = RepositoryConfigUtil.getContext(con, id);
                if (context == null) continue;
                con.clear(context);
                con.remove(context, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY_CONTEXT, new Resource[0]);
                changed = true;
            }
            con.commit();
        }
        finally {
            con.close();
        }
        return changed;
    }

    public static Resource getContext(RepositoryConnection con, String repositoryID) throws RepositoryException, RepositoryConfigException {
        Resource context = null;
        Statement idStatement = RepositoryConfigUtil.getIDStatement(con, repositoryID);
        if (idStatement != null) {
            context = idStatement.getContext();
        }
        return context;
    }

    private static Statement getIDStatement(RepositoryConnection con, String repositoryID) throws RepositoryException, RepositoryConfigException {
        Literal idLiteral = con.getRepository().getValueFactory().createLiteral(repositoryID);
        List<Statement> idStatementList = con.getStatements(null, RepositoryConfigSchema.REPOSITORYID, idLiteral, true, new Resource[0]).asList();
        if (idStatementList.size() == 1) {
            return idStatementList.get(0);
        }
        if (idStatementList.isEmpty()) {
            return null;
        }
        throw new RepositoryConfigException("Multiple ID-statements for repository ID " + repositoryID);
    }
}

