/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Ivan Churkin (brox IT Solutions GmbH) - initial creator Sebastian Voigt (brox IT Solutions GmbH)
 **********************************************************************************************************************/
package org.eclipse.smila.datamodel.test;

import java.io.ByteArrayOutputStream;

import junit.framework.TestCase;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;

/**
 * The Class TestRecordFilters.
 */
public class TestXmlSerializationUtils extends TestCase {

  /** The logger. */
  protected final org.apache.commons.logging.Log _log = org.apache.commons.logging.LogFactory.getLog(this
    .getClass());

  private Record _record;

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#setUp()
   */
  @Override
  protected void setUp() throws Exception {
    _record = RecordCreator.createTestRecord1();

  }

  public void _test_XmlDeserialize_Stream2Byte() throws Exception {
    final ByteArrayOutputStream xml = XmlSerializationUtils.serialize2stream(_record);

    final Record deserialize = XmlSerializationUtils.deserialize(xml.toByteArray());
    assertNotNull(deserialize);

  }

  /**
   * @see https://bugs.eclipse.org/bugs/show_bug.cgi?id=349811
   */
  public void test_XmlDeserialize_String2String() throws Exception {
    final String xml = XmlSerializationUtils.serialize2string(_record);
    _log.debug(xml);
    final Record deserialize = XmlSerializationUtils.deserialize(xml);
    assertNotNull(deserialize);

    final byte[] attachment = deserialize.getAttachmentAsBytes("Content");
    // this failes ATM
    // assertNotNull(attachment);
  }

  public void test_XmlDeserialize_Bytes2Bytes() throws Exception {

    final byte[] xml = XmlSerializationUtils.serialize2byteArray(_record);
    _log.debug(xml);
    final Record deserialize = XmlSerializationUtils.deserialize(xml);
    assertNotNull(deserialize);

  }

  /**
   * Test record serialization to/from byte[] keeping attachments.
   * 
   * @throws Exception
   *           if any error occurs
   */
  public void testAttachmentSerialization() throws Exception {

    final byte[] serializedRecord = XmlSerializationUtils.serialize2byteArray(_record);
    assertNotNull(serializedRecord);

    final Record deserializedRecord = XmlSerializationUtils.deserialize(serializedRecord);
    assertNotNull(deserializedRecord);
    assertTrue(deserializedRecord.hasAttachments());
    final byte[] attachment1 = deserializedRecord.getAttachmentAsBytes("attachment1");
    assertNotNull(attachment1);
    assertEquals("my very first attachment", new String(attachment1));
  }
}
