/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.http.client.test.httphandler;

import java.io.IOException;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.ARequestHandler;

public class AnyHandler extends ARequestHandler {

  @Override
  public void handle(final HttpExchange exchange) throws IOException {
    final Any requestObject = new IpcAnyReader().readJsonStream(exchange.getRequestStream());
    final AnyMap response = requestObject.getFactory().createAnyMap();
    response.put("method", exchange.getRequestMethod());
    response.put("resource", exchange.getRequestURI());
    response.put("data", requestObject);
    exchange.setResponseStatus(200);
    exchange.setResponseHeader("Content-Type", "application/json; charset=utf-8");
    exchange.setResponseHeader("Transfer-Encoding", "chunked");
    new IpcAnyWriter().writeJsonStream(response, exchange.getResponseStream());
    exchange.getResponseStream().close();
  }

}
