/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.impl.base;

import java.io.IOException;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;

/** Interface for objects that actually execute the HTTP requests in the RestClient. */
public interface HttpRequestExecutor {

  /** The host and port this executor is currently talking to. */
  String getHostAndPort();

  /** execute request. */
  HttpResponse execute(HttpClient client, HttpUriRequest request) throws IOException;

}
