/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.feed;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.util.CrawlingContext;
import org.eclipse.smila.taskworker.TaskContext;

public class FeedCrawlingContext extends CrawlingContext {

  private final long _maxRecordsPerBulk;

  private final Any _feedUrls;

  private final Any _deltaProperties;

  /** creates a crawling context from the taskContext. */
  public FeedCrawlingContext(final TaskContext taskContext) {
    super(taskContext, false);
    final AnyMap taskParameters = taskContext.getTaskParameters();

    _maxRecordsPerBulk =
      getNonNegativeParameter(taskParameters, FeedCrawlerWorker.TASK_PARAM_MAX_RECORDS_PER_BULK,
        FeedCrawlerWorker.MAX_RECORDS_PER_BULK_DEFAULT);
    if (_maxRecordsPerBulk == 0) {
      throw new IllegalArgumentException("Task parameter " + FeedCrawlerWorker.TASK_PARAM_MAX_RECORDS_PER_BULK
        + " must be greater than 0");
    }
    _feedUrls = taskParameters.get(FeedCrawlerWorker.TASK_PARAM_FEED_URL);
    if (_feedUrls == null || _feedUrls.isEmpty()) {
      throw new IllegalArgumentException("Parameter '" + FeedCrawlerWorker.TASK_PARAM_FEED_URL + "' of task "
        + taskContext.getTask().getTaskId() + " is null or empty");
    }
    _deltaProperties = taskParameters.get(FeedCrawlerWorker.TASK_PARAM_DELTA_PROPERTIES);
  }

  public long getMaxRecordsPerBulk() {
    return _maxRecordsPerBulk;
  }

  public Any getFeedUrls() {
    return _feedUrls;
  }

  public Any getDeltaProperties() {
    return _deltaProperties;
  }
}
