/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.web.fetcher;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpResponseInputStream extends InputStream {

  private final String _url;

  private final HttpResponse _response;

  private InputStream _responseBody;

  private final boolean _isRedirect;

  public HttpResponseInputStream(final String url, final HttpResponse response, final boolean isRedirect)
    throws IOException {
    _response = response;
    _url = url;
    _isRedirect = isRedirect;
  }

  public String getUrl() {
    return _url;
  }

  public boolean isRedirect() {
    return _isRedirect;
  }

  /** get the underlying request object. */
  public HttpResponse getResponse() {
    return _response;
  }

  /** get the underlying request object. */
  public HttpEntity getResponseEntity() {
    if (_response == null) {
      return null;
    }
    return _response.getEntity();
  }

  @Override
  public int read() throws IOException {
    ensureStream();
    if (_responseBody == null) {
      return -1;
    }
    return _responseBody.read();
  }

  @Override
  public int read(final byte[] b, final int off, final int len) throws IOException {
    ensureStream();
    if (_responseBody == null) {
      return -1;
    }
    return _responseBody.read(b, off, len);
  }

  @Override
  public int available() throws IOException {
    ensureStream();
    if (_responseBody == null) {
      return 0;
    }
    return _responseBody.available();
  }

  @Override
  public long skip(final long n) throws IOException {
    ensureStream();
    if (_responseBody == null) {
      return 0;
    }
    return _responseBody.skip(n);
  }

  @Override
  public void close() {
    if (_responseBody != null) {
      IOUtils.closeQuietly(_responseBody);
    }
    if (getResponseEntity() != null) {
      try {
        EntityUtils.consume(_response.getEntity());
      } catch (final IOException ex) {
        ; // ignore.
      }
    }
  }

  private void ensureStream() throws IOException {
    if (_responseBody == null && getResponseEntity() != null) {
      _responseBody = _response.getEntity().getContent();
    }
  }

}
