/*******************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.importing.test;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.smila.importing.util.test.TestFilePathNormalizer;
import org.eclipse.smila.importing.util.test.TestPropertyNameMapper;
import org.eclipse.smila.importing.util.test.TestRegexPatternMatcher;

/**
 * Test suite for org.eclipse.smila.importing bundle.
 */
public final class AllTests {

  /** name of test bundle. */
  public static final String BUNDLE_ID = "org.eclipse.smila.importing.test";

  /** Private default Constructor to avoid instance creation. */
  private AllTests() {
  }

  /**
   * Creates test suite.
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite("Tests for org.eclipse.smila.importing bundle");
    suite.addTestSuite(TestUpdatePusherTaskGenerator.class);
    suite.addTestSuite(TestFileCrawling.class);
    suite.addTestSuite(TestRemoteFileCrawling.class);
    suite.addTestSuite(TestRemoteFileCrawlingWithFailover.class);
    suite.addTestSuite(TestWebCrawling.class);
    suite.addTestSuite(TestRegexPatternMatcher.class);
    suite.addTestSuite(TestPropertyNameMapper.class);
    suite.addTestSuite(TestFilePathNormalizer.class);
    return suite;
  }

}
