/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.importing.httphandler;

import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.importing.VisitedLinksService;

/** Super class for visited handlers. */
public abstract class AVisitedHandler extends JsonRequestHandler {

  /** service reference. */
  protected VisitedLinksService _visitedService;

  /** DS service injection method. */
  public void setVisitedLinksService(final VisitedLinksService visitedService) {
    _visitedService = visitedService;
  }

  /** DS service removal method. */
  public void unsetVisitedLinksService(final VisitedLinksService visitedService) {
    if (_visitedService == visitedService) {
      _visitedService = null;
    }
  }

}
