/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH.  
 * All rights reserved. This program and the accompanying materials are made available
 * under the terms of the Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation               
 **********************************************************************************************************************/

package org.eclipse.smila.ipc.util;

import java.io.IOException;

import org.eclipse.smila.ipc.IpcToken;

/**
 * A Validator can be implemented to validate an IPC protocol format. (@see Ipc2BonTrafo)
 * 
 * @author aweber
 */
public interface IpcValidator {

  /**
   * Called for each incoming token.
   * 
   * @param token
   *          the next token
   * @param value
   *          the next token's value
   * @throws IOException
   *           validation error
   */
  void validate(IpcToken token, String value) throws IOException;
}
