/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.jobmanager.exceptions.IllegalJobStateException;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.persistence.RunStorage;

/** Tests for JobRunDataProvider class. */
public class TestJobRunDataProvider extends JobManagerTestBase {

  /** tests set/getCustomData(). */
  public void testCustomData() throws Exception {
    final String worker = "myTestWorker";
    // create a job for testing
    final String jobName = "testCustomData";
    final String workerParameterValue = "test";
    final AnyMap parameters = createJobParameters(workerParameterValue, STORE_NAME, STORE_NAME);
    addJob(jobName, "testWorkflow", parameters);
    final String jobRunId = startJob(jobName);

    // test with RUNNING job
    _jobRunDataProvider.setCustomData(jobName, jobRunId, worker, "data-1".getBytes(), "path1", "path2");
    byte[] data = _jobRunDataProvider.getCustomData(jobName, jobRunId, worker, "path1", "path2");
    assertEquals("data-1", new String(data));

    // overwrite existing data
    _jobRunDataProvider.setCustomData(jobName, jobRunId, worker, "data-2".getBytes(), "path1", "path2");
    data = _jobRunDataProvider.getCustomData(jobName, jobRunId, worker, "path1", "path2");
    assertEquals("data-2", new String(data));

    // set another data node
    _jobRunDataProvider.setCustomData(jobName, jobRunId, worker, "data-3".getBytes(), "path3");
    data = _jobRunDataProvider.getCustomData(jobName, jobRunId, worker, "path3");
    assertEquals("data-3", new String(data));
    data = _jobRunDataProvider.getCustomData(jobName, jobRunId, worker, "path1", "path2");
    assertEquals("data-2", new String(data));

    // set data node node without path (this is allowed)
    _jobRunDataProvider.setCustomData(jobName, jobRunId, worker, "data-4".getBytes());
    data = _jobRunDataProvider.getCustomData(jobName, jobRunId, worker);
    assertEquals("data-4", new String(data));
    
    // test for "FINISHING" state    
    final RunStorage jobRunStorage = getService(RunStorage.class);
    jobRunStorage.setJobState(jobName, jobRunId, JobState.FINISHING);
    _jobRunDataProvider.setCustomData(jobName, jobRunId, worker, "data-5".getBytes(), "path5");
    data = _jobRunDataProvider.getCustomData(jobName, jobRunId, worker, "path5");
    assertEquals("data-5", new String(data));
    
    // test for "COMPLETING" state        
    jobRunStorage.setJobState(jobName, jobRunId, JobState.COMPLETING);
    _jobRunDataProvider.setCustomData(jobName, jobRunId, worker, "data-6".getBytes(), "path6");
    data = _jobRunDataProvider.getCustomData(jobName, jobRunId, worker, "path6");
    assertEquals("data-6", new String(data));
  }

  /** tests exceptions when set/getCustomData(). */
  public void testCustomDataErrors() throws Exception {
    // create a job for testing
    final String jobName = "testCustomDataErrors";
    final String workerParameterValue = "test";
    final AnyMap parameters = createJobParameters(workerParameterValue, STORE_NAME, STORE_NAME);

    try {
      _jobRunDataProvider.setCustomData(jobName, "aJobRunId", "worker", "data".getBytes(), "path");
      fail("Expected exception cause job is not existing");
    } catch (JobManagerException e) {
      ; // expected
    }

    addJob(jobName, "testWorkflow", parameters);
    try {
      _jobRunDataProvider.setCustomData(jobName, "aJobRunId", "worker", "data".getBytes());
      fail("Expected exception cause job is not running");
    } catch (JobManagerException e) {
      ; // expected
    }

    final String jobRunId = startJob(jobName);    
    final RunStorage jobRunStorage = getService(RunStorage.class);
    jobRunStorage.setJobState(jobName, jobRunId, JobState.CANCELLING);
    try {
      _jobRunDataProvider.setCustomData(jobName, jobRunId, "worker", "data".getBytes());
      fail("Expected exception cause job state doesn't allow setting custom data");
    } catch (IllegalJobStateException e) {
      ; // expected
    }
    
    jobRunStorage.setJobState(jobName, jobRunId, JobState.CLEANINGUP);
    try {
      _jobRunDataProvider.setCustomData(jobName, jobRunId, "worker", "data".getBytes());
      fail("Expected exception cause job state doesn't allow setting custom data");
    } catch (IllegalJobStateException e) {
      ; // expected
    }

  }
}
