/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test;

import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.JobRunDefinitions;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;
import org.eclipse.smila.jobmanager.exceptions.PersistenceException;
import org.eclipse.smila.jobmanager.persistence.JobRunListener;
import org.eclipse.smila.jobmanager.persistence.RunStorage;

/**
 * Test for JobRunWatcher.
 */
public class TestJobRunWatcher extends JobManagerTestBase implements JobRunListener {

  private static final String TEST_WORKFLOW = "testWorkflow";

  private static final String TEST_JOB = "testJob";

  private static final String TEST_JOB_RUN_ID = "testJobRunId";

  private RunStorage _runStorage;

  private JobRunDefinitions _jobRunDefs;

  private String _notifiedJob;
  
  private int _notifyCounter;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _runStorage = getService(RunStorage.class);
    _jobRunDefs = new JobRunDefinitions();
    _jobRunDefs.setWorkflowDefinition(createWorkflowDefinition());
    _jobRunDefs.setJobDefinition(createJobDefinition(TEST_JOB));
  }

  @Override
  public void notifiyAboutJobRunCompletion(String jobName) {
    _notifiedJob = jobName;
    _notifyCounter++;
  }

  /** test that Watcher is triggered on job run deletion and notifies listener. */
  public void testWatcher() throws Exception {
    _notifiedJob = null;
    _notifyCounter = 0;
    // start (dummy) job run with myself as Listener     
    _runStorage.startJobRun(TEST_JOB, TEST_JOB_RUN_ID, JobRunMode.STANDARD, _jobRunDefs);
    _runStorage.startJobRun("anotherJob", "anotherJobRunId", JobRunMode.STANDARD, _jobRunDefs);
    _runStorage.registerJobRunListener(this, TEST_JOB);
    _runStorage.registerJobRunListener(this, "anotherJob");

    // complete job (run) -> should trigger watcher to call my notifiyAboutJobRunCompletion() method     
    _runStorage.deleteJobRun(TEST_JOB, TEST_JOB_RUN_ID);
    Thread.sleep(1000);
    assertNotNull("Should have been notified", _notifiedJob);
    assertEquals(TEST_JOB, _notifiedJob);
    assertEquals(1, _notifyCounter);
  }

  /** @return WorkflowDefinition for test. */
  private WorkflowDefinition createWorkflowDefinition() throws PersistenceException {
    return _defPersistence.getWorkflow(TEST_WORKFLOW);
  }

  /** @return JobDefinition for test. */
  private JobDefinition createJobDefinition(final String jobName) throws Exception {
    final AnyMap jobAny = DataFactory.DEFAULT.createAnyMap();
    jobAny.put("name", jobName);
    jobAny.put("workflow", TEST_WORKFLOW);
    final AnyMap parameters = AccessAny.FACTORY.createAnyMap();
    parameters.put("tempStore", "temp");
    parameters.put("store", "store");
    parameters.put("workerParameter", "bla");
    jobAny.put("parameters", parameters);
    final JobDefinition jobDef = new JobDefinition(jobAny);    
    return jobDef;
  }

}
