/*******************************************************************************
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tobias Liefke - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.processing.pipelets.boilerpipe.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Test suite combining all Boilerpipe tests.
 * 
 * @author Tobias Liefke
 */
public final class AllTests {

  /**
   * Prevent creation.
   */
  private AllTests() {
  }

  /**
   * Create the test suite.
   * 
   * @return the test suite
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite("Test for org.eclipse.smila.processing.pipelets.boilerpipe");
    // $JUnit-BEGIN$
    suite.addTestSuite(TestBoilerpipePipelet.class);
    // $JUnit-END$
    return suite;
  }
}
