/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Tobias Liefke - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.processing.pipelets.test;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Attachment;
import org.eclipse.smila.processing.bpel.test.AWorkflowProcessorTest;

/**
 * Tests the {@link org.eclipse.smila.processing.pipelets.JSONReaderPipelet} and
 * {@link org.eclipse.smila.processing.pipelets.JSONWriterPipelet}.
 * 
 * @author Tobias Liefke
 */
public class TestJsonIOPipelets extends AWorkflowProcessorTest {

  /**
   * Name of the pipeline to test.
   */
  public static final String PIPELINE_NAME = "JsonIOPipeline";

  /**
   * @return name of pipeline to test
   */
  @Override
  protected String getPipelineName() {
    return PIPELINE_NAME;
  }

  /**
   * test code.
   * 
   * @throws Exception
   *           test fails
   */
  public void test() throws Exception {
    // Create input record
    final String requestId = createBlackboardRecord("source", "key");
    AnyMap metadata = getBlackboard().getMetadata(requestId);
    metadata.put("attribute1", "value1");
    metadata.put("attribute2", 2);
    metadata.put("attribute3", true);
    final AnyMap testMap = getBlackboard().getDataFactory().createAnyMap();
    testMap.put("mapAttribute", "mapValue");
    metadata.put("mapAttribute", testMap);
    final AnySeq testSeq = getBlackboard().getDataFactory().createAnySeq();
    testSeq.add("seqValue");
    metadata.put("seqAttribute", testSeq);

    // Execute pipeline
    final String[] resultIds = getProcessor().process(PIPELINE_NAME, getBlackboard(), new String[] { requestId });
    assertEquals(1, resultIds.length);
    assertEquals(requestId, resultIds[0]);

    // Test if "testJSONWriterWithAttributes" succeeded
    metadata = getBlackboard().getMetadata(resultIds[0]);
    final Attachment json1 = getBlackboard().getAttachment(resultIds[0], "json1");
    assertNotNull(json1);
    final String jsonString = new String(json1.getAsBytes(), "UTF-8");
    assertEquals(jsonString, "{\"attribute1\":\"value1\",\"attribute2\":2}");

    // Test if "testJSONReaderWithAttribute" succeeded
    final Any jsonObject1 = metadata.get("jsonObject1");
    assertNotNull(jsonObject1);
    assertTrue(jsonObject1.isMap());
    assertEquals(jsonObject1.asMap().getStringValue("attribute1"), "value1");
    assertTrue(jsonObject1.asMap().getValue("attribute2").isNumber());

    // Test if "testJSONWriterWithObject" succeeded
    final Any json2 = metadata.get("json2");
    assertNotNull(json2);
    assertTrue(json2.isString());
    assertTrue(json2.toString().contains("\"mapAttribute\" : \"mapValue\""));
    assertTrue(json2.toString().contains("\"_recordid\""));

    // Test if "testJSONReaderWithObject" succeeded
    assertEquals(metadata.getStringValue("attribute1"), "value1");
  }
}
