/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Tobias Liefke - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.processing.pipelets.test;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.jobmanager.WorkflowRunInfo;
import org.eclipse.smila.processing.pipelets.PushRecordsPipelet;

/**
 * Test the {@link PushRecordsPipelet}.
 * 
 * @author Tobias Liefke
 */
public class TestPushRecordsPipelet extends APipeletTest {

  /**
   * Test code.
   * 
   * @throws Exception
   *           if test fails
   */
  public void test() throws Exception {
    // Configure pipelet
    final PushRecordsPipelet pipelet = new PushRecordsPipelet();
    final AnyMap config = getBlackboard().getDataFactory().createAnyMap();
    config.put("job", "TestJob");
    pipelet.configure(config);
    final BulkBuilderStub bulkBuilder = new BulkBuilderStub();
    pipelet.setBulkbuilderService(bulkBuilder);

    // Execute pipelet
    final String requestId = createBlackboardRecord("source", "key");
    getBlackboard().getMetadata(requestId).put("attribute1", "value1");
    final String[] resultIds = pipelet.process(getBlackboard(), new String[] { requestId });
    assertEquals(1, resultIds.length);
    assertEquals(requestId, resultIds[0]);

    // Check pushed records
    final Map<String, Record> jobRecords = bulkBuilder._records.get("TestJob");
    assertNotNull(jobRecords);
    assertEquals(jobRecords.size(), 1);
    assertNotNull(jobRecords.get(requestId));
    assertEquals(jobRecords.get(requestId).getMetadata().getStringValue("attribute1"), "value1");
  }

  private static final class BulkBuilderStub implements BulkbuilderService {
    private Map<String, Map<String, Record>> _records = new HashMap<String, Map<String, Record>>();

    public WorkflowRunInfo addRecord(final String jobName, final Record record) throws BulkbuilderException,
      InvalidRecordException {
      Map<String, Record> jobRecords = _records.get(jobName);
      if (jobRecords == null) {
        jobRecords = new HashMap<String, Record>();
        _records.put(jobName, jobRecords);
      }
      jobRecords.put(record.getId(), record);

      return new WorkflowRunInfo(jobName, "dummyJobId", "dummyWorkflowId");
    }

    public WorkflowRunInfo deleteRecord(final String jobName, final Record record) throws BulkbuilderException,
      InvalidRecordException {
      // Nothing to do
      return new WorkflowRunInfo(jobName, "dummyJobId", "dummyWorkflowId");
    }

    public WorkflowRunInfo commitJob(final String jobName) throws BulkbuilderException {
      // Nothing to do
      return new WorkflowRunInfo(jobName, "dummyJobId", "dummyWorkflowId");
    }

    public WorkflowRunInfo addToMicroBulk(final String jobName, final Record record, final String microBulkId)
      throws BulkbuilderException, InvalidRecordException {
      // Nothing to do
      return new WorkflowRunInfo(jobName, "dummyJobId", "dummyWorkflowId");
    }

    public WorkflowRunInfo finishMicroBulk(final String jobName, final String microBulkId)
      throws BulkbuilderException {
      // Nothing to do
      return new WorkflowRunInfo(jobName, "dummyJobId", "dummyWorkflowId");
    }

    public void removeMicroBulk(final String microBulkId) {
      // Nothing to do
    }
  }
}
