/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Tobias Liefke - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.processing.pipelets.test;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.processing.bpel.test.AWorkflowProcessorTest;

/**
 * Test the ReplacePipelet.
 * 
 * @author Tobias Liefke
 */
public class TestReplacePipelet extends AWorkflowProcessorTest {

  /**
   * Name of the pipeline to test.
   */
  public static final String PIPELINE_NAME = "ReplacePipeline";

  /**
   * @return name of pipeline to test
   */
  @Override
  protected String getPipelineName() {
    return PIPELINE_NAME;
  }

  /**
   * Test code.
   * 
   * @throws Exception
   *           if test fails
   */
  public void test() throws Exception {
    final String requestId = createBlackboardRecord("source", "key");
    getBlackboard().getMetadata(requestId).put("attribute1",
      getBlackboard().getDataFactory().createStringValue("feel and steel"));
    final String[] resultIds = getProcessor().process(PIPELINE_NAME, getBlackboard(), new String[] { requestId });
    assertEquals(1, resultIds.length);
    assertEquals(requestId, resultIds[0]);

    // Check if input attribute remains the same
    final Any attribute1 = getBlackboard().getMetadata(resultIds[0]).get("attribute1");
    assertNotNull(attribute1);
    assertTrue(attribute1.isString());
    assertEquals(attribute1.asValue().asString(), "feel and steel");

    // Check if substring replace works
    final Any attribute2 = getBlackboard().getMetadata(resultIds[0]).get("attribute2");
    assertNotNull(attribute2);
    assertTrue(attribute2.isString());
    assertEquals(attribute2.asValue().asString(), "fool and stool");

    // Check if regexp replace works
    final Any attribute3 = getBlackboard().getMetadata(resultIds[0]).get("attribute3");
    assertNotNull(attribute3);
    assertTrue(attribute3.isString());
    assertEquals(attribute3.asValue().asString(), "feed and steel");

    // Check if mapping replacements works
    final Any attribute4 = getBlackboard().getMetadata(resultIds[0]).get("attribute4");
    assertNotNull(attribute4);
    assertTrue(attribute4.isString());
    assertEquals(attribute4.asValue().asString(), "touch and stone");
  }
}
