/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Tobias Liefke - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.processing.pipelets.test;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.processing.bpel.test.AWorkflowProcessorTest;

/**
 * Test the ScriptPipelet.
 * 
 * @author Tobias Liefke
 */
public class TestScriptPipelet extends AWorkflowProcessorTest {

  /**
   * Name of the pipeline to test.
   */
  public static final String PIPELINE_NAME = "ScriptPipeline";

  /**
   * @return name of pipeline to test
   */
  @Override
  protected String getPipelineName() {
    return PIPELINE_NAME;
  }

  /**
   * Test code.
   * 
   * @throws Exception
   *           if test fails
   */
  public void test() throws Exception {
    // Execute pipeline with "test" in attribute 1
    final String requestId = createBlackboardRecord("source", "key");
    getBlackboard().getMetadata(requestId).put("attribute1",
      getBlackboard().getDataFactory().createStringValue("test"));
    final String[] resultIds = getProcessor().process(PIPELINE_NAME, getBlackboard(), new String[] { requestId });
    assertEquals(1, resultIds.length);
    assertEquals(requestId, resultIds[0]);

    // Check in input attribute remains the same (depends on the script)
    final Any attribute1 = getBlackboard().getMetadata(resultIds[0]).get("attribute1");
    assertNotNull(attribute1);
    assertTrue(attribute1.isString());
    assertEquals(attribute1.asValue().asString(), "test");

    // Check in target attribute contains the new value (see script in the pipeline)
    final Any attribute2 = getBlackboard().getMetadata(resultIds[0]).get("attribute2");
    assertNotNull(attribute2);
    assertTrue(attribute2.isString());
    assertEquals(attribute2.asValue().asString(), "test the best");

    // check also that the configuration value has been read and added.
    final Any attribute3 = getBlackboard().getMetadata(resultIds[0]).get("attribute3");
    assertEquals(attribute3.asValue().asLong().longValue(), 12345L);

    // Execute pipeline with "no test" -> No record should be returned
    getBlackboard().getMetadata(requestId).put("attribute1",
      getBlackboard().getDataFactory().createStringValue("no test"));
    final String[] resultIds2 = getProcessor().process(PIPELINE_NAME, getBlackboard(), new String[] { requestId });
    assertEquals(0, resultIds2.length);
  }
}
