/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.processing.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.processing.httphandler.PipeletsHandler;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/** unit tests for {@link PipeletsHandler}. */
public class TestPipeletsHandler extends DeclarativeServiceTestCase {

  private JsonRequestHandler _handler;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _handler = getService(JsonRequestHandler.class, "(uriPattern=/pipelets/?$)");
  }

  /** test if correct handler class was found. */
  public void testHandlerType() throws Exception {
    assertTrue(_handler instanceof PipeletsHandler);
  }

  /** test result of a get request. */
  public void testGetRequest() throws Exception {
    final AnyMap result = (AnyMap) _handler.process("GET", "/smila/pipelets", null, null);
    assertTrue(result.containsKey("pipelets"));
    final AnySeq pipelets = result.getSeq("pipelets");
    assertFalse(pipelets.isEmpty());
    final Collection<String> classNames = new ArrayList<String>();
    final Collection<String> expectedClassesWithErrors =
      Arrays.asList("org.eclipse.smila.processing.test.WillNotBeFoundPipelet",
        "org.eclipse.smila.processing.test.InvalidClassAndParametersPipelet",
        "org.eclipse.smila.processing.test.InvalidParam1Pipelet",
        "org.eclipse.smila.processing.test.InvalidParam2Pipelet");
    for (final Any element : pipelets) {
      assertTrue(element instanceof AnyMap);
      final AnyMap pipelet = (AnyMap) element;
      assertTrue(pipelet.containsKey("class"));
      final String className = pipelet.getStringValue("class");
      classNames.add(className);
      assertTrue(pipelet.containsKey("url"));
      assertTrue(pipelet.getStringValue("url").endsWith(pipelet.getStringValue("class") + "/"));
    }
    // assert that also the pipelets with invalid class name and parameter descriptions were present.
    assertTrue(classNames.containsAll(expectedClassesWithErrors));
  }

}
