/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.processing.worker.test;

import static java.lang.String.format;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;

public class BpelWorkerTestPipelet3 implements Pipelet {

  /** The logger. */
  protected final org.apache.commons.logging.Log _log = org.apache.commons.logging.LogFactory.getLog(this
    .getClass());

  public static int s_instanceCounter; // static for reading result in test

  public int _instanceNo; // static for reading result in test

  private String _configVal;

  /**
   * 
   */
  public BpelWorkerTestPipelet3() {
    synchronized (getClass()) {
      _instanceNo = ++s_instanceCounter;
    }
  }

  @Override
  public String[] process(final Blackboard blackboard, final String[] recordIds) throws ProcessingException {
    for (String id : recordIds) {
      try {
        final AnyMap metadata = blackboard.getMetadata(id);
        final String key = "instanceNo" + _instanceNo;
        final AnySeq seq = metadata.getSeq("bpel order", true);
        seq.add(_configVal);
        _log.info(format("added: %s=%s", key, _configVal));
      } catch (BlackboardAccessException e) {
        throw new ProcessingException(id, e);
      }

    }
    // dont do anything
    return recordIds;
  }

  @Override
  public void configure(final AnyMap configuration) throws ProcessingException {
    _configVal = configuration.getStringValue("param");
    _log.info(format("instance %d: config value: %s", _instanceNo, _configVal));
  }

}
