/**
 * 
 */
package org.eclipse.smila.solr;

import junit.framework.TestCase;

import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.params.ShardParams;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.Blackboard.Get;
import org.eclipse.smila.blackboard.impl.BlackboardFactoryImpl;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.solr.search.SolrQueryBuilder;
import org.eclipse.smila.solr.search.SolrQueryConverter;
import org.eclipse.smila.solr.search.SolrQueryParameterAccessor;

/**
 * @author pwissel
 * 
 */
public class Shards_Test extends TestCase {

  private Blackboard _blackboard;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _blackboard = new BlackboardFactoryImpl().createTransientBlackboard();
  }

  public void test_Shards() throws Exception {
    final Record record = _blackboard.getRecord("TestRecord", Get.NEW);
    final SolrQueryBuilder builder = new SolrQueryBuilder("TestWorkflow", record);
    final String[] shards = { "http://server-1:8983/solr", "http://server-2:8983/solr" };
    builder.setShards(shards);
    final String id = builder.getQuery().getId();
    final SolrQueryParameterAccessor accessor = new SolrQueryParameterAccessor(_blackboard, id);
    assertEquals(2, accessor.getShards().size());
    assertEquals(shards[0], accessor.getShards().getStringValue(0));
    assertEquals(shards[1], accessor.getShards().getStringValue(1));
    final SolrQuery query = new SolrQueryConverter(accessor).toSolrQuery(null);
    assertEquals(2, query.getParams(ShardParams.SHARDS).length);
    assertEquals(shards[0], query.getParams(ShardParams.SHARDS)[0]);
    assertEquals(shards[1], query.getParams(ShardParams.SHARDS)[1]);
  }

}
