/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.solr;

import java.util.List;

import junit.framework.TestCase;

import org.eclipse.smila.solr.admin.SolrAdministration;

/**
 * @author tmenzel
 */
public class SolrAdmin_Embedded_Test extends TestCase {

  /** The logger. */
  protected final org.apache.commons.logging.Log _log = org.apache.commons.logging.LogFactory.getLog(this
    .getClass());

  private SolrAdministration _solrAdmin;

  /**
   */
  @Override
  protected void setUp() throws Exception {
    _solrAdmin = Activator.getInstance().getSolrManager().getSolrAdministration();
  }

  //
  // public void test_CreateFrom() throws Exception {
  // final String targetCore = getName();
  // try {
  // final String create = _solrAdmin.create(SolrConstants.DEFAULT_CORE, targetCore);
  // _log.debug("create response: " + create);
  //
  // final SolrPingResponse ping = Activator.getInstance().getSolrManager().getSolrServer(targetCore).ping();
  // assertFalse(SolrQueryUtils.responseStatusIsError(ping));
  //
  // final File solrWorkspace = WorkspaceHelper.createWorkingDir(Activator.BUNDLE_ID);
  // final File targetCoreData = new File(solrWorkspace, FilenameUtils.concat(targetCore, "data"));
  //
  // assertTrue("Data folder doesnt exist: " + targetCoreData, targetCoreData.isDirectory());
  // } finally {
  // _solrAdmin.unload(targetCore);
  // }
  // }

  /** assert that the default core name is reported. */
  public void test_GetCoreNames() throws Exception {
    final List<String> names = _solrAdmin.getCoreNames();
    assertEquals(1, names.size());
    assertTrue(names.contains(SolrConstants.DEFAULT_CORE));
  }

  /** assert that names from default schema are reported. */
  public void test_GetFieldNames() throws Exception {
    final List<String> names = _solrAdmin.getFieldNames(SolrConstants.DEFAULT_CORE);
    assertEquals(13, names.size());
    assertTrue(names.contains("_recordid"));
    assertTrue(names.contains("_source"));
    assertTrue(names.contains("LastModifiedDate"));
    assertTrue(names.contains("Filename"));
    assertTrue(names.contains("Url"));
    assertTrue(names.contains("Path"));
    assertTrue(names.contains("Extension"));
    assertTrue(names.contains("Size"));
    assertTrue(names.contains("MimeType"));
    assertTrue(names.contains("Content"));
    assertTrue(names.contains("Title"));
    assertTrue(names.contains("Author"));
    assertTrue(names.contains("spell"));
  }

  /** assert that an exception is thrown when asking for the fields of an undefined core. */
  public void test_GetFieldNames_ErrorUnknownCore() throws Exception {
    try {
      _solrAdmin.getFieldNames("NoSuchCore");
      fail("should not work");
    } catch (final Exception ex) {
      System.out.println(ex);
    }

  }

}
