/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import junit.framework.TestCase;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.solr.index.SolrIndexPipelet;

/**
 * The Class SolrSearchPipelet_AddResultRecords_Test.
 * 
 * @author tmenzel
 */
public class SolrIndexPipelet_Delete_Test extends TestCase {

  /** The logger. */
  private final org.apache.commons.logging.Log _log = org.apache.commons.logging.LogFactory.getLog(this.getClass());

  /** The _pipelet. */
  SolrIndexPipelet _pipelet = new SolrIndexPipelet();

  private AnyMap _config;

  private Record _record;

  /**
   */
  @Override
  protected void setUp() throws Exception {
    //    <rec:Val key="ServerUrl">http://localhost:8983/solr</rec:Val>
    //    <rec:Val key="ExecutionMode">DELETE</rec:Val>
    //    <rec:Val key="CoreName">DefaultCore</rec:Val>
    _config = DataFactoryCreator.createDefaultFactory().createAnyMap();
    _config.put(SolrConstants.CORE_NAME, SolrConstants.DEFAULT_CORE);
    _config.put(SolrConstants.EXECUTION_MODE, SolrConstants.ExecutionMode.DELETE.name());

    _record = DataFactoryCreator.createDefaultFactory().createRecord();

  }

  /**
   * 
   */
  public void test_Configure() throws Exception {
    _pipelet.configure(_config);
  }

}
