/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import java.io.IOException;

import junit.framework.TestCase;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.impl.BlackboardFactoryImpl;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;

/**
 * common functions and fields for solr pipelet tests
 */
public class SolrPipeletTestBase extends TestCase {

  /** The logger. */
  protected final org.apache.commons.logging.Log _log = org.apache.commons.logging.LogFactory.getLog(this.getClass());

  protected Blackboard _blackboard;

  protected SolrServer _solrServer;

  protected AnyMap _config;

  protected Record _record;

  /**
   * sets the server for the {@link SolrConstants#DEFAULT_CORE} and clears the index for a fresh start.
   */
  @Override
  protected void setUp() throws Exception {
    _log.info("##########################################################");
    _log.info("test case: " + getName());
    _log.info("----------------------------------------------------------");

    _config = DataFactoryCreator.createDefaultFactory().createAnyMap();
    _config.put(SolrConstants.CORE_NAME, SolrConstants.DEFAULT_CORE);

    _blackboard = new BlackboardFactoryImpl().createTransientBlackboard();

    _solrServer = Activator.getInstance().getSolrManager().getSolrServer(SolrConstants.DEFAULT_CORE);
    //clear the index in advance before the (next) test
    clearIndex();
  }

  protected void clearIndex() throws SolrServerException, IOException {
    _solrServer.deleteByQuery("*:*");
    _solrServer.commit(true, true);
  }

}
