/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import java.util.ArrayList;
import java.util.List;

import org.apache.solr.common.SolrInputDocument;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.solr.search.SolrQueryBuilder;
import org.eclipse.smila.solr.search.SolrSearchPipelet;

/**
 * base class for tests intending to blackbox test the {@link SolrSearchPipelet} using the embedded solr. setup of the
 * tests is done directly with solr API but against the pre-configed DefaultCore, to make setup less arduous.
 */
public class SolrSearchPipeletTestBase extends SolrPipeletTestBase {

  /** WORKFLOW. */
  protected static final String WORKFLOW = "SearchPipeline";

  /**
   * most test cases need just one field for tests and this is it.
   */
  protected String _solrField;

  /** The _pipelet. */
  protected Pipelet _pipelet = new SolrSearchPipelet();

  protected final List<SolrInputDocument> _solrDocs = new ArrayList<SolrInputDocument>();

  protected SolrQueryBuilder _queryBuilder;

  /**
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    // it uses one of the dynamic fields that dont do any analyzing, which might go into the test's way.
    _solrField = getName() + "_s";
    // there query string isnt set here as it should be done by the sub class/test
    _queryBuilder = new SolrQueryBuilder(WORKFLOW);
    _queryBuilder.setId(getName());
    _queryBuilder.setIndexName(SolrConstants.DEFAULT_CORE);

    _record = _queryBuilder.getQuery();
    _blackboard.setRecord(_record);
    // _pipelet.configure(_config);
  }

  /**
   * Add solr doc with the id derived from the suffix and puts the given value into the {@link #_solrField}.
   */
  protected void addSolrDoc(String idSuffix, String fieldValue) {
    addSolrDoc(getId(idSuffix), _solrField, fieldValue);
  }

  /**
   * Add solr doc with given id and puts the given value into the given field.
   */
  protected void addSolrDoc(String id, String field, Object... fieldValues) {
    final SolrInputDocument solrDocument = new SolrInputDocument();
    solrDocument.setField(SolrConstants.CORE_FIELD_ID, id);
    for (Object fieldValue : fieldValues) {
      solrDocument.addField(field, fieldValue);
    }
    _solrDocs.add(solrDocument);
  }

  protected String getId(String idSuffix) {
    return getName() + "_" + idSuffix;
  }

  protected void indexAndCommit() throws Exception {
    _solrServer.add(_solrDocs);
    _solrServer.commit(true, true);
  }

}
