/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.util.MetadataUtils;
import org.eclipse.smila.datamodel.util.MetadataUtils.Mode;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.solr.search.SolrResultAccessor;
import org.eclipse.smila.solr.search.SpellcheckSolrConstants;

/**
 * 
 * @author tmenzel
 */
public class SolrSearchPipelet_DidYouMean_Test extends SolrSearchPipeletTestBase {

  /**
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _solrField = "Content";
  }

  /**
   * simple case to ensure that this works as written in the wiki.
   */
  public void test_Dym_Simple() throws Exception {
    // index docs
    addSolrDoc("1",
      "This is a simple text without real meaning as i dont want to bust my behind for smth. with more sense.");
    addSolrDoc("2", "It is just used for testing.");
    indexAndCommit();
    // setup search
    _queryBuilder.setQuery("Content:rust");
    _queryBuilder.setNativeParam(SpellcheckSolrConstants.SPELLCHECK, true);
    _queryBuilder.setNativeParam(SpellcheckSolrConstants.SPELLCHECK_COUNT, 5);
    _queryBuilder.setNativeParam(SpellcheckSolrConstants.SPELLCHECK_EXTENDED_RESULTS, true);
    _queryBuilder.setNativeParam(SpellcheckSolrConstants.SPELLCHECK_COLLATE, true);

    _pipelet.process(_blackboard, new String[] { _record.getId() });
    _log.debug("result record: " + XmlSerializationUtils.serialize2string(_record));

    // verify
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    final AnyMap spellResult = results.getSpellCheckResult();
    if (spellResult != null) {
      assertEquals(3, spellResult.size());
      final AnyMap rustSuggestions =
        MetadataUtils.getMap(spellResult, Mode.CREATE_ALL, SpellcheckSolrConstants.SUGGESTIONS, "rust",
          SpellcheckSolrConstants.SUGGESTIONS);
      assertEquals(2, rustSuggestions.size());
      assertEquals(1, rustSuggestions.getMap("just").getLongValue("freq").longValue());
      assertEquals(1, rustSuggestions.getMap("bust").getLongValue("freq").longValue());
      assertEquals("Content:bust", spellResult.getStringValue("collation"));
    } else {
      fail("No spellcheck result");
    }
  }

}
