/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.solr;

import static org.apache.commons.lang.StringUtils.join;

import java.util.ArrayList;

import junit.framework.Assert;

import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.solr.search.SolrResultAccessor;

/**
 * @author tmenzel
 * 
 */
public final class SolrTestUtils {

  /**
   */
  private SolrTestUtils() {
  }

  /**
   * Asserts that exactly all of the given Ids are in the results, no more no less but oder is irrelevant.
   */
  protected static void assertResultIds(final AnySeq resultRecords, Object... ids) {
    Assert.assertEquals(ids.length, resultRecords.size());
    for (Object id : ids) {
      boolean found = false;
      for (Any any : resultRecords) {
        final AnyMap resultItems = any.asMap();
        if (StringUtils.equals(id.toString(), resultItems.getStringValue(Record.RECORD_ID))) {
          found = true;
          break;
        }
      }
      if (!found) {
        Assert.fail("id not found: " + id);
      }
    }
  }

  /**
   * Asserts that the ids in the result are in the exact same order as given.
   */
  protected static void assertResultIdsInOrder(final SolrResultAccessor resultRecords, Object... ids) {
    final String expected = join(ids, " ");
    
    final ArrayList<String> actuals = new ArrayList<String>();
    for (Any any : resultRecords.getResultRecords()) {
      final AnyMap resultItems = any.asMap();
      actuals.add(resultItems.getStringValue(Record.RECORD_ID));
    }
    
    Assert.assertEquals(expected, join(actuals, " "));
    
  }

}
