/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import static org.apache.commons.lang.StringUtils.join;
import static org.apache.commons.lang.StringUtils.split;
import junit.framework.TestCase;

import org.apache.solr.client.solrj.SolrQuery;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.Blackboard.Get;
import org.eclipse.smila.blackboard.impl.BlackboardFactoryImpl;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.solr.search.SolrQueryBuilder;
import org.eclipse.smila.solr.search.SolrQueryConverter;
import org.eclipse.smila.solr.search.SolrQueryParameterAccessor;

/**
 * The Class SolrSearchPipelet_AddResultRecords_Test.
 * 
 * @author tmenzel
 */
public class ToSolrQueryConverter_Test extends TestCase {

  private SolrQueryBuilder _builder;

  private SolrQueryParameterAccessor _accessor;

  /**
   */
  public void test_MainParams() throws Exception {
    final String resultFields = "Id,MimeType,Size,Extension,Title,Url,LastModifiedDate,Path,Filename,Author";

    _builder.setQuery("dummy query string");
    _builder.addFields(split(resultFields, ','));
    _builder.setOffset(2);
    _builder.setMaxCount(4);
    _builder.addFilterQuery("test filter string 1");
    _builder.addFilterQuery("test filter string 2");

    final SolrQuery solrQuery = new SolrQueryConverter(_accessor).toSolrQuery(null);

    assertEquals("dummy query string", solrQuery.getQuery());
    assertEquals(2, solrQuery.getStart().intValue());
    assertEquals(4, solrQuery.getRows().intValue());
    // the field score is always returned and hard coded!
    assertEquals(resultFields + ",score,_recordid", solrQuery.getFields());
    assertEquals("test filter string 1#test filter string 2", join(solrQuery.getFilterQueries(), '#'));
  }

  /**
   * Sets the up.
   * 
   * @throws Exception
   *           the exception {@inheritDoc}
   * @see junit.framework.TestCase#setUp()
   */
  @Override
  protected void setUp() throws Exception {
    final Blackboard blackboard = new BlackboardFactoryImpl().createTransientBlackboard();
    final String queryRecordId = "TestId";
    final Record record = blackboard.getRecord(queryRecordId, Get.NEW);
    _builder = new SolrQueryBuilder("TestWorkflow", record);
    _accessor = new SolrQueryParameterAccessor(blackboard, queryRecordId);

  }

}
