/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.taskmanager.test.taskgenerator;

import java.util.List;
import java.util.Map;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.taskgenerator.DefaultTaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.taskmanager.Task;

/**
 * TaskGenerator that may be triggered to throw an exception when generating completion tasks.
 */
public class ExceptionalTaskGenerator extends DefaultTaskGenerator implements TaskGenerator {

  /** throw exception on next completion task generation. */
  private static boolean s_exceptionOnNextCompletionTask;

  /** throw unchecked exception on next completion task generation. */
  private static boolean s_uncheckedExceptionOnNextCompletionTask;

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return "exceptionOnDemand";
  }

  /** {@inheritDoc} */
  @Override
  public List<Task> createCompletionTasks(final Map<String, Bucket> inputBuckets,
    final Map<String, Bucket> outputBuckets, final AnyMap parameters, final String workerName)
    throws TaskGeneratorException {
    if (s_exceptionOnNextCompletionTask) {
      setExceptionOnNextCompletionTask(false);
      throw new TaskGeneratorException("This exception has been called for.");
    } else if (s_uncheckedExceptionOnNextCompletionTask) {
      setUncheckedExceptionOnNextCompletionTask(false);
      throw new IllegalArgumentException("This exception has been called for.");
    } else {
      return super.createCompletionTasks(inputBuckets, outputBuckets, parameters, workerName);
    }
  }

  /** . */
  public static boolean isExceptionOnNextCompletionTask() {
    return s_exceptionOnNextCompletionTask;
  }

  /** . */
  public static void setExceptionOnNextCompletionTask(final boolean exceptionOnNextCompletionTask) {
    ExceptionalTaskGenerator.s_exceptionOnNextCompletionTask = exceptionOnNextCompletionTask;
  }

  /**
   * @return the s_uncheckedExceptionOnNextCompletionTask
   */
  public static boolean isUncheckedExceptionOnNextCompletionTask() {
    return s_uncheckedExceptionOnNextCompletionTask;
  }

  /**
   * @param s_uncheckedExceptionOnNextCompletionTask
   *          the s_uncheckedExceptionOnNextCompletionTask to set
   */
  public static void setUncheckedExceptionOnNextCompletionTask(
    final boolean s_uncheckedExceptionOnNextCompletionTask) {
    ExceptionalTaskGenerator.s_uncheckedExceptionOnNextCompletionTask = s_uncheckedExceptionOnNextCompletionTask;
  }

}
