/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.taskmanager.test.taskgenerator;

import java.util.List;
import java.util.Map;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.taskgenerator.DefaultTaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.Task;

/**
 * TaskGenerator that creates tasks with uniqueness tags.
 */
public class UniquenessTaskGenerator extends DefaultTaskGenerator implements TaskGenerator {

  private static String s_uniquenessTag = "unique";

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return "uniqueness";
  }

  /** {@inheritDoc} */
  @Override
  public List<Task> createTasks(final Map<String, List<BulkInfo>> changedInput,
    final Map<String, Bucket> inputBuckets, final Map<String, Bucket> outputBuckets, final AnyMap parameters,
    final String workerName) throws TaskGeneratorException {
    final List<Task> taskList =
      super.createTasks(changedInput, inputBuckets, outputBuckets, parameters, workerName);
    for (final Task t : taskList) {
      String tag = "unique";
      if (s_uniquenessTag != null) {
        tag = s_uniquenessTag;
        s_uniquenessTag = null;
      }
      t.getProperties().put(Task.PROPERTY_UNIQUENESS_TAG, tag);
    }
    return taskList;
  }

  /** sets the tag for next task(s) that are created. */
  static public void setUniquenessTagForNextTaskCreation(final String uTag) {
    s_uniquenessTag = uTag;
  }
}
