/*******************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. 
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.tika.test;

import junit.framework.Test;
import junit.framework.TestSuite;


/**  Test suite for org.eclipse.smila.tika bundle. */
public final class AllTests {

  public static final String BUNDLE_ID = "org.eclipse.smila.tika.test";
  
  private AllTests() {
  }

  /**
   * Creates test suite.
   * 
   * @return Test suite.
   */
  public static Test suite() {

    final TestSuite suite = new TestSuite("Tests for org.eclipse.smila.tika");
    // $JUnit-BEGIN$
    suite.addTestSuite(TestTikaPipelet.class);
    suite.addTestSuite(TestTikaPipeletWithAttachments.class);
    //suite.addTestSuite(TestKeepHyphens.class);
    //suite.addTestSuite(TestKeepHyphensWithAttachments.class);
    suite.addTestSuite(TestExtractProperties.class);
    suite.addTestSuite(TestExtractPropertiesFromMediaFiles.class);
    //suite.addTestSuite(TestMaxLength.class);
    //suite.addTestSuite(TestPageBreaks.class);
    //suite.addTestSuite(TestTikaLanguageIdentifier.class);
    suite.addTestSuite(TestLanguageIdentifyPipelet.class);
    suite.addTestSuite(TestTikaMimeTypeIdentifier.class);
    suite.addTestSuite(TestMimeTypeIdentifyPipelet.class);
    suite.addTestSuite(TestMimeTypeIdentifyPipeline.class);

    // $JUnit-END$
    return suite;
  }
}
