/*******************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. 
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.tika.test.manual;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.tika.TikaPipelet;
import org.eclipse.smila.tika.test.TestExtractPropertiesFromMediaFiles;

/** test for extracting metadata. */
public class ManualTestExtractPropertiesFromMediaFiles extends TestExtractPropertiesFromMediaFiles {  

  public void testOggMetadata() throws Exception {
    final String fileName = "13-Untitled.ogg";
    final AnyMap additionalRecordParams = DataFactory.DEFAULT.createAnyMap();
    final AnySeq extractProperties = DataFactory.DEFAULT.createAnySeq();
    additionalRecordParams.put(TikaPipelet.PROP_EXTRACT_PROPERTIES, extractProperties);

    final AnyMap author = DataFactory.DEFAULT.createAnyMap();
    author.put("metadataName", "Author");
    author.put("targetAttribute", "ATT_Author");
    extractProperties.add(author);
    final AnyMap title = DataFactory.DEFAULT.createAnyMap();
    title.put("metadataName", "title");
    title.put("targetAttribute", "ATT_Titel");
    extractProperties.add(title);
    final AnyMap album = DataFactory.DEFAULT.createAnyMap();
    album.put("metadataName", "xmpDM:album");
    album.put("targetAttribute", "ATT_Album");
    extractProperties.add(album);
    _expectedMetadata.put("ATT_Author", "Fant\u00f4mas");
    _expectedMetadata.put("ATT_Titel", "Untitled");
    _expectedMetadata.put("ATT_Album", "The Director's Cut");
    executeTest(fileName, additionalRecordParams);
  }

  public void testMp4Metadata() throws Exception {
    final String fileName = "video.mp4";
    final AnyMap additionalRecordParams = DataFactory.DEFAULT.createAnyMap();
    final AnySeq extractProperties = DataFactory.DEFAULT.createAnySeq();
    additionalRecordParams.put(TikaPipelet.PROP_EXTRACT_PROPERTIES, extractProperties);

    final AnyMap height = DataFactory.DEFAULT.createAnyMap();
    height.put("metadataName", "xmpDM:audioChannelType");
    height.put("targetAttribute", "ATT_1");
    extractProperties.add(height);
    final AnyMap width = DataFactory.DEFAULT.createAnyMap();
    width.put("metadataName", "xmpDM:audioSampleRate");
    width.put("targetAttribute", "ATT_2");
    extractProperties.add(width);
    _expectedMetadata.put("ATT_1", "Mono");
    _expectedMetadata.put("ATT_2", "48000");
    executeTest(fileName, additionalRecordParams);
  }

}
