/*******************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. 
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.tika.test.manual;

import org.eclipse.smila.tika.test.TestKeepHyphens;

public class ManualTestKeepHyphens extends TestKeepHyphens {

  /** Test txt. */
  public void testTXT() throws Exception {
    final String fileName = "keepHyphens/test.txt";
    doTextExtractionRemoveHyphens(fileName);
    doTextExtractionKeepHyphens(fileName);
  }

  /** Test utf-8 txt. */
  public void testUTF8TXT() throws Exception {
    final String fileName = "keepHyphens/utf-8.txt";
    doTextExtractionRemoveHyphens(fileName);
    doTextExtractionKeepHyphens(fileName);
  }  

  /** Test pdf created from 2010 doc. */
  public void testPDF() throws Exception {
    final String fileName = "keepHyphens/MSWORD_2010.pdf";
    doTextExtractionRemoveHyphens(fileName);
    doTextExtractionKeepHyphens(fileName);
  }

}
