/*******************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.tika.test.manual;

import org.eclipse.smila.tika.test.TestTikaPipelet;

/**
 * Test that should run after removing standard tika.deps bundle and updating downloaded tika dependencies in SMILA
 * extensions.
 */
public class ManualTestTikaPipelet extends TestTikaPipelet {
  /** Test txt. */
  public void testTXT() throws Exception {
    final String fileName = "test.txt";
    doTextExtractionWithContentType(fileName, "text/plain");
    doTextExtractionWithFileName(fileName);
    doTextExtraction(fileName);
  }

  /** Test utf-8 txt. */
  public void testUTF8TXT() throws Exception {
    final String fileName = "utf-8.txt";
    doTextExtractionWithContentType(fileName, "text/plain");
    doTextExtractionWithFileName(fileName);
    doTextExtraction(fileName);
  }

  /** Test utf-8 txt with different extension. */
  public void testUTF8WithWrongExtension() throws Exception {
    final String fileName = "utf-8.1";
    doTextExtractionWithContentType(fileName, "text/plain");
    doTextExtractionWithFileName(fileName);
    doTextExtraction(fileName);
  }

  /** Test utf-8 txt without extension. */
  public void testUTF8WithoutExtension() throws Exception {
    final String fileName = "utf-8";
    doTextExtractionWithContentType(fileName, "text/plain");
    doTextExtractionWithFileName(fileName);
    doTextExtraction(fileName);
  }

  /** Test html. */
  public void testHTML() throws Exception {
    final String fileName = "test.html";
    doTextExtractionWithContentType(fileName, "text/html");
    doTextExtractionWithFileName(fileName);
    doTextExtraction(fileName);
    doHtmlExtraction(fileName);
  }

  /** Test pdf. */
  public void testPDF() throws Exception {
    final String fileName = "test.pdf";
    doTextExtractionWithContentType(fileName, "application/pdf");
    doTextExtractionWithFileName(fileName);
    doTextExtraction(fileName);
    doHtmlExtraction(fileName);
  }

  /** tests pdf created by office 2010. */
  public void testPDFCreatedByOffice2010() throws Exception {
    final String fileName = "SMILA_PPT_FROM_DOCX_2010.pdf";
    doTextExtractionWithContentType(fileName, "application/pdf");
    doTextExtractionWithFileName(fileName);
    doTextExtraction(fileName);
    doHtmlExtraction(fileName);
  }

}
