/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.versions.test;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.test.DeclarativeServiceTestCase;
import org.eclipse.smila.versions.VersionManager;
import org.eclipse.smila.versions.internal.SmilaVersionProvider;
import org.eclipse.smila.versions.internal.VersionManagerImpl;

/** Test for {@link VersionManager} class. */
public class TestVersionManager extends DeclarativeServiceTestCase {

  /** tests getting OSGI service. */
  public void testService() throws Exception {
    final VersionManager service = getService(VersionManager.class);
    assertTrue(service instanceof VersionManagerImpl);
  }
  
  /** tests getVersionInfos(). */
  public void testGetVersionInfos() throws Exception {
    final VersionManager service = getService(VersionManager.class);
    final AnyMap versioninfos = service.getVersionInfos();
    assertNotNull(versioninfos);
    assertTrue(versioninfos.containsKey(SmilaVersionProvider.PROVIDER_NAME));
  }
}
