/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.versions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.versions.VersionManager;
import org.eclipse.smila.versions.VersionProvider;

public class VersionManagerImpl implements VersionManager {

  /** local logger. */
  private final Log _log = LogFactory.getLog(getClass());

  /** the registered VersionProviders. */
  private final Collection<VersionProvider> _versionProviders = new ArrayList<>();

  @Override
  public AnyMap getVersionInfos() {
    final Map<String, Any> sortedComponentVersions = new TreeMap<>();
    for (final VersionProvider provider : _versionProviders) {
      sortedComponentVersions.putAll(provider.getVersionInfo());
    }
    final AnyMap versions = DataFactory.DEFAULT.createAnyMap();
    versions.putAll(sortedComponentVersions);
    return versions;
  }

  /** Add the given VersionProvider. */
  public void addVersionProvider(final VersionProvider provider) {
    _versionProviders.add(provider);
    if (_log.isInfoEnabled()) {
      _log.info("Added VersionProvider '" + provider.getClass().getSimpleName() + "' to "
        + getClass().getSimpleName());
    }
  }

  /** Removes the given VersionProvider. */
  public void removeVersionProvider(final VersionProvider provider) {
    _versionProviders.remove(provider);
    if (_log.isInfoEnabled()) {
      _log.info("Removed VersionProvider '" + provider.getClass().getSimpleName() + "' from "
        + getClass().getSimpleName());
    }
  }

};
