/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.workermanager.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Suite combining all taskworker junit tests.
 */
public final class AllTests {
  /**
   * The Constant BUNDLE_ID.
   */
  public static final String BUNDLE_ID = "org.eclipse.smila.workermanager.test";

  /**
   * utility class, do not create instances.
   */
  private AllTests() {
  }

  /**
   * @return suite for all org.eclipse.smila.workermanager tests
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite(BUNDLE_ID);
    // $JUnit-BEGIN$
    suite.addTestSuite(TestWorkerManager.class);
    suite.addTestSuite(TestWorkerPool.class);
    suite.addTestSuite(TestTaskKeepAlive.class);
    suite.addTestSuite(TestScaleUpControl.class);
    // $JUnit-END$
    return suite;
  }
}
