/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.io.IODataObject;
import org.eclipse.smila.taskworker.util.Counters;

public abstract class IODataObjects {
    protected final Map<String, List<BulkInfo>> _dataObjects;
    protected final Map<String, List<IODataObject>> _ioData = new HashMap<String, List<IODataObject>>();
    private final ObjectStoreService _objectStore;

    public IODataObjects(Map<String, List<BulkInfo>> dataObjects, ObjectStoreService objectStore) {
        this._dataObjects = dataObjects;
        this._objectStore = objectStore;
    }

    public int getDataObjectCount(String slotName) {
        if (this._dataObjects.containsKey(slotName)) {
            return this._dataObjects.get(slotName).size();
        }
        return 0;
    }

    public BulkInfo getDataObject(String slotName) {
        return this.getDataObject(slotName, 0);
    }

    public BulkInfo getDataObject(String slotName, int index) {
        if (index < this.getDataObjectCount(slotName)) {
            return this._dataObjects.get(slotName).get(index);
        }
        return null;
    }

    public Set<String> getSlotNames() {
        return this._dataObjects.keySet();
    }

    public ObjectStoreService getObjectStore() {
        return this._objectStore;
    }

    protected boolean canCreate(String slotName, int index) {
        int dataObjectCount = this.getDataObjectCount(slotName);
        if (dataObjectCount > index) {
            List<IODataObject> slot = this._ioData.get(slotName);
            if (slot == null) {
                slot = new ArrayList<IODataObject>();
                int i = 0;
                while (i <= dataObjectCount) {
                    slot.add(null);
                    ++i;
                }
                this._ioData.put(slotName, slot);
            }
            return slot.get(index) == null;
        }
        return false;
    }

    protected void putIOData(String slotName, int index, IODataObject ioData) {
        List<IODataObject> slotInputs = this._ioData.get(slotName);
        slotInputs.add(index, ioData);
    }

    protected Map<String, List<IODataObject>> getIOData() {
        return this._ioData;
    }

    public void addCounters(Map<String, Number> counters, String name) {
        String durationPerformName = "duration.perform." + name;
        for (Map.Entry<String, List<IODataObject>> slots : this._ioData.entrySet()) {
            String slotName = slots.getKey();
            String prefix = String.valueOf(name) + "." + slotName;
            for (IODataObject io : slots.getValue()) {
                long durationPerform;
                if (io == null) continue;
                long durationOpen = io.getDurationOpen();
                if (durationOpen > 0L) {
                    Counters.addDuration(counters, "duration.iodata.open", io.getDurationOpen());
                }
                if ((durationPerform = io.getDurationPerform()) > 0L) {
                    Counters.addDuration(counters, durationPerformName, durationPerform);
                    Counters.addDuration(counters, String.valueOf(durationPerformName) + "." + slotName, durationPerform);
                }
                Counters.addAll(counters, io.getCounter(), prefix);
            }
        }
    }
}

