/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server;

import java.util.Map;
import java.util.TreeMap;

public final class HttpStatus {
    public static final int UNKNOWN = 0;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NO_CONTENT = 204;
    public static final int BAD_REQUEST = 400;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int UNPROCESSABLE_ENTITY = 422;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int SERVICE_UNAVAILABLE = 503;
    private static Map<Integer, String> s_codeToName = new TreeMap<Integer, String>();

    static {
        s_codeToName.put(200, "OK 200");
        s_codeToName.put(204, "NO_CONTENT 204");
        s_codeToName.put(201, "CREATED 201");
        s_codeToName.put(202, "ACCEPTED 202");
        s_codeToName.put(400, "BAD_REQUEST 400");
        s_codeToName.put(404, "NOT_FOUND 404");
        s_codeToName.put(410, "GONE 410");
        s_codeToName.put(422, "UNPROCESSABLE_ENTITY 422");
        s_codeToName.put(500, "INTERNAL_SERVER_ERROR 500");
        s_codeToName.put(503, "SERVICE_UNAVAILABLE 503");
    }

    private HttpStatus() {
    }

    public static String name(int status) {
        return s_codeToName.get(status);
    }
}

