/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.memdao.BpelDAOConnectionImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.MessageRouteDaoImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.utils.CollectionUtils;

class CorrelatorDaoImpl
extends DaoBaseImpl
implements CorrelatorDAO {
    private static final Log __log = LogFactory.getLog(CorrelatorDaoImpl.class);
    private String _correlatorId;
    private List<MsgQueueEntry> _messages = new ArrayList<MsgQueueEntry>();
    private List<MessageRouteDaoImpl> _routes = new ArrayList<MessageRouteDaoImpl>();
    private BpelDAOConnectionImpl _conn;

    CorrelatorDaoImpl(String string, BpelDAOConnectionImpl bpelDAOConnectionImpl) {
        this._correlatorId = string;
        this._conn = bpelDAOConnectionImpl;
    }

    public MessageExchangeDAO dequeueMessage(CorrelationKey correlationKey) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("dequeueEarliest: MATCHING correlationKey=" + correlationKey));
        }
        Iterator<MsgQueueEntry> iterator = this._messages.iterator();
        while (iterator.hasNext()) {
            MsgQueueEntry msgQueueEntry = iterator.next();
            Set set = (Set)CollectionUtils.makeCollection(HashSet.class, (Object[])msgQueueEntry.keys);
            if (correlationKey != null && !set.contains(correlationKey)) continue;
            iterator.remove();
            return msgQueueEntry.message;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"dequeueEarliest: MATCH NOT FOUND!");
        }
        return null;
    }

    public MessageRouteDAO findRoute(CorrelationKey correlationKey) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("findRoute: key=" + correlationKey));
        }
        for (MessageRouteDaoImpl messageRouteDaoImpl : this._routes) {
            if ((messageRouteDaoImpl._ckey != null || correlationKey != null) && (messageRouteDaoImpl._ckey == null || correlationKey == null || !messageRouteDaoImpl._ckey.equals((Object)correlationKey))) continue;
            return messageRouteDaoImpl;
        }
        return null;
    }

    public String getCorrelatorId() {
        return this._correlatorId;
    }

    public void removeRoutes(String string, ProcessInstanceDAO processInstanceDAO) {
        ((ProcessInstanceDaoImpl)processInstanceDAO).removeRoutes(string);
    }

    public void enqueueMessage(MessageExchangeDAO messageExchangeDAO, CorrelationKey[] correlationKeyArray) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("enqueueProcessInvocation: data=" + messageExchangeDAO + " keys=" + CollectionUtils.makeCollection(ArrayList.class, (Object[])correlationKeyArray)));
        }
        MsgQueueEntry msgQueueEntry = new MsgQueueEntry(messageExchangeDAO, correlationKeyArray);
        this._messages.add(msgQueueEntry);
    }

    public void addRoute(String string, ProcessInstanceDAO processInstanceDAO, int n, CorrelationKey correlationKey) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addRoute: target=" + processInstanceDAO + " correlationKey=" + correlationKey));
        }
        final MessageRouteDaoImpl messageRouteDaoImpl = new MessageRouteDaoImpl((ProcessInstanceDaoImpl)processInstanceDAO, string, correlationKey, n);
        this._conn.defer(new Runnable(){

            public void run() {
                CorrelatorDaoImpl.this._routes.add(messageRouteDaoImpl);
            }
        });
    }

    public boolean checkRoute(CorrelationKey correlationKey) {
        return true;
    }

    void _removeRoutes(String string, ProcessInstanceDaoImpl processInstanceDaoImpl) {
        Iterator<MessageRouteDaoImpl> iterator = this._routes.iterator();
        while (iterator.hasNext()) {
            MessageRouteDaoImpl messageRouteDaoImpl = iterator.next();
            if (!messageRouteDaoImpl._groupId.equals(string) && string != null || messageRouteDaoImpl._instance != processInstanceDaoImpl) continue;
            iterator.remove();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{CorrelatorDaoImpl corrId=");
        stringBuffer.append(this._correlatorId);
        stringBuffer.append(" waiters=");
        stringBuffer.append(this._routes);
        stringBuffer.append(" messages=");
        stringBuffer.append(this._messages);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private class MsgQueueEntry {
        public final MessageExchangeDAO message;
        public final CorrelationKey[] keys;

        private MsgQueueEntry(MessageExchangeDAO messageExchangeDAO, CorrelationKey[] correlationKeyArray) {
            this.message = messageExchangeDAO;
            this.keys = correlationKeyArray;
        }
    }
}

